package MEvent::Message;
use strict;

use vars qw(@ISA);
use MEvent;
@ISA = qw(MEvent);

use MCoreTools;

sub new {
  my ($class, %param) = @_;
  
  my $self = $class->SUPER::new(%param);
  
  $self->{method} = $param{method} or croak "No method specified";
  my $targ = $self->{target} = $param{target} or croak "No message specified";
  if (ref $targ and ref $targ ne 'MObjectRef') {
    croak "Target must be package or MObjectRef";
  }
  
  $self;
}

sub run {
  my ($self) = @_;
  
  my ($t, $m) = ($self->{target}, $self->{method});
  eval { $t->$m() };
  if ($@) {
    mudlog "ERROR: death while executing message event '$self->{name}' (".$t."->$m):\n$@";
  }
}
